/**************************************************************************
 *                                                                        *
 * libfsearch 1.1                                                         *
 * part of libindexer package                                             *
 * Copyright (C) 2012 Fabien Menemenlis (nihilist@dead-inside.org)        *
 *                                                                        *
 * This library is free software; you can redistribute it and/or          *
 * modify it under the terms of the GNU Lesser General Public             *
 * License as published by the Free Software Foundation; either           *
 * version 2.1 of the License, or (at your option) any later version.     *
 *                                                                        *
 * This library is distributed in the hope that it will be useful,        *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 * Lesser General Public License for more details.                        *
 *                                                                        *
 * You should have received a copy of the GNU Lesser General Public       *
 * License along with this library; if not, write to the Free Software    *
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  *
 * MA  02111-1307  USA                                                    *
 *                                                                        *
 **************************************************************************/

#ifndef _LIB_FSEARCH_H_
#define _LIB_FSEARCH_H_

#include <stdio.h>
#include <sys/types.h>

#include "idxdefines.h"


typedef struct {
    FILE *foffdb, *fdatadb;
    int fsoffcnt;
    int fidx;
    FILE *foff;
    int globalcount;
} s_fsearch;


/*
 * fsearch_init() must be called with .off / .db / .idx files basename on
 * files created by libindexer
 */
extern s_fsearch *fsearch_init(char *basename);

/*
 * look for records with words in "query" string (separated by spaces)
 * docids is the result set (integers giving the record number in the
 * original file)
 * maxid is either 0 if you want no limit (docids will be reallocated
 * and must by NULL initialised if no previous allocation was made)
 * or an integer that will limit the results in the result set
 */
extern unsigned int fsearch_seek(s_fsearch *fs, char *query, s_pos **docids, int maxid);

/*
 * returns the offset in the original indexed file for the given record
 * number
 */
extern off_t fsearch_getoffset(s_fsearch *fs, int id);

/*
 * prepares a string before sending a query
 * fsearch_clearstring removes all non standard latin-1 characters
 * fsearch_clearstringlnk keeps some of them when they are between 2 words
 * (handy when looking for words like A.B.C, clearstring would find
 * C A B too)
 */
extern char *fsearch_clearstring(char *orig);
extern char *fsearch_clearstringlnk(char *orig);

extern void fsearch_close(s_fsearch *fs);


#endif
