/*--------------------------------------------------------------------------------
 * Copyright (c) 2008, Jean-Christophe Dufour. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 4. Neither the name of the copyright holder nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *--------------------------------------------------------------------------------
 * Title: dhash
 * Revision: 0.1
 * Author: Jean-Christophe Dufour (jc@uhlu.com)
 * $Date: 2008/09/08 15:04:35 $
 * Description: on disk hash primitives
 *--------------------------------------------------------------------------------
 */
#ifndef _DHASH_H_
#define _DHASH_H_


//#define DHASHSZ 500000003
#define DHASHSZ 573259391

/*
 so far, 468.000.000 different words
 offsets are 5 bytes long
 we need to add a byte to code the number of offsets in a bucket (256 max)
 note: if we ever need more than 256 offsets per bucket, then the hash function
       must be really crappy...
 ok, 500000003 * 6 * 3.000.000.000 bytes =~ 3GB
*/

unsigned int dhash_hash(char *str);
unsigned int dhash_hash2(char *str, char *end);
inline unsigned int dhash_prime(unsigned int n);
#endif
