/*--------------------------------------------------------------------------------
 * Copyright (c) 2008, Jean-Christophe Dufour. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 4. Neither the name of the copyright holder nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *--------------------------------------------------------------------------------
 * Title: dhash
 * Revision: 0.1
 * Author: Jean-Christophe Dufour (jc@uhlu.com)
 * $Date: 2008/09/08 15:04:35 $
 * Description: on disk hash primitives 
 *--------------------------------------------------------------------------------
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "dhash.h"


/*
 * Based on an algorithm by E. Knuth in The Art Of Computer Programming Volume 3
 */
inline unsigned int dhash_hash(char *str) {
    register unsigned int h;
    char *end;

    h = (unsigned int)strlen(str);
    end = str + h;
    while (str < end)
        h = ((h << 5) ^ (h >> 27)) ^ *str++;

    return(h % DHASHSZ);
}

inline unsigned int dhash_hash2(char *str, char *end) {
    register unsigned int h = (unsigned int)(end - str);

    while (str < end)
        h = ((h << 5) ^ (h >> 27)) ^ *str++;

    return(h % DHASHSZ);
}


inline int dhash_isprime(unsigned int n) {
    unsigned long long i;


    if (n < 2)
        return(0);

    for (i = 2; i * i < n + 1; i++)
        if (n % i == 0)
            return(0);

    return(1);
}


inline unsigned int dhash_prime(unsigned int n) {

    while(!dhash_isprime(n))
        n++;

    return(n);
}

