/**************************************************************************
 *                                                                        *
 * libindexer 1.1                                                         *
 * Copyright (C) 2012 Fabien Menemenlis (nihilist@dead-inside.org)        *
 *                                                                        *
 * This library is free software; you can redistribute it and/or          *
 * modify it under the terms of the GNU Lesser General Public             *
 * License as published by the Free Software Foundation; either           *
 * version 2.1 of the License, or (at your option) any later version.     *
 *                                                                        *
 * This library is distributed in the hope that it will be useful,        *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 * Lesser General Public License for more details.                        *
 *                                                                        *
 * You should have received a copy of the GNU Lesser General Public       *
 * License along with this library; if not, write to the Free Software    *
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  *
 * MA  02111-1307  USA                                                    *
 *                                                                        *
 **************************************************************************/

#ifndef _LIB_INDEXER_
#define _LIB_INDEXER_

/*
 * user defined read function
 * data is alphanumeric input buffer that will be modified by latin "to upper" conversion table
 * ndata is input buffer that will not be modified and indexed as is. Each record in the buffer
 * must be separated by the SOH ascii character (\1)
 * note that data is indexed before ndata, that means word positions in data buffer come first
 * id is current document id as given by the indexer
 */
typedef void (*indexer_read_func) (FILE *f, char **data, char **ndata, int *id);

/*
 * forkc process number
 * pname program name (used for IPC communication)
 * outname .off / .db created files basename
 * inname file to index
 * user_readdata() callback used to extract data from input file
 * count records in input file (used as a hint for stop words, use 0 if you
 * don't know / don't care)
 */
extern int indexer(int forkc, char *pname, char *outname, char *inname, indexer_read_func user_readdata, int count);

#endif
